#include "bits/stdc++.h"

using namespace std;

//#define int long long
#define sz(a) (int)((a).size())
#define all(a) (a).begin(), (a).end()
#define rall(a) (a).rbegin(), (a).rend()

#ifdef home
#define dbg(x) cerr << #x << " = " << x << endl;
#else
#define dbg(x) 42
#endif

//#pragma GCC optimize("O3")
//#pragma GCC target("avx2")

template <typename T>
istream & operator >> (istream &is, vector<T> &v) {
    for (auto &x : v) is >> x;
    return is;
}

template <typename T>
ostream & operator << (ostream &os, vector<T> &v) {
    for (int i = 0; i < sz(v); i++) {
        os << v[i];
        if (i != sz(v) - 1)
            os << " ";
    }
    return os;
}


mt19937_64 rng(chrono::high_resolution_clock::now().time_since_epoch().count());

int getRandom (int l, int r) {
    return rng() % (r - l + 1) + l;
}

struct Fenwick {
    vector<int> t;
    int n;

    void init (int k) {
        n = k + 10;
        t.assign(n + 10, 0);
    }

    int sum (int x) {
        int ans = 0;
        for (; x > 0; x -= x & -x) {
            ans += t[x];
        }
        return ans;
    }

    void upd (int k, int x) {
        for (; k <= n; k += k & -k) {
            t[k] += x;
        }
    }

    int sum (int l, int r) {
        return sum(r) - sum(l - 1);
    }
};

const int mod = 998244353;

int add (int a, int b) {
    return (a + b) % mod;
}

int sub (int a, int b) {
    return (a - b + mod) % mod;
}

int mul (int a, int b) {
    return 1ll * a * b % mod;
}

int stupid (int n, int k, int segments) {
    int ans = 0;
    int dp[n + 1][k + 1][k + 1][segments + 1];
    for (int i = 0; i <= n; i++) {
        for (int j = 0; j <= k; j++) {
            for (int mx = 0; mx <= k; mx++) {
                for (int d = 0; d <= segments; d++) {
                    dp[i][j][mx][d] = 0;
                }
            }
        }
    }
    dp[1][1][1][1] = 1;
    for (int i = 1; i <= n - 1; i++) {
        for (int len = 1; len <= k; len++) {
            for (int mx = 1; mx <= k; mx++) {
                for (int seg = 1; seg <= segments; seg++) {
                    if (seg != segments) {
                        dp[i + 1][1][mx][seg + 1] = add(dp[i + 1][1][mx][seg + 1], dp[i][len][mx][seg]);
                    }
                    int nxt_mx = max(mx, len + 1);
                    if (len + 1 <= k) {
                        dp[i + 1][len + 1][nxt_mx][seg] = add(dp[i + 1][len + 1][nxt_mx][seg], dp[i][len][mx][seg]);
                    }
                }
            }
        }
    }
    for (int len = 1; len <= k; len++) {
        ans = add(ans, dp[n][len][k][segments]);
    }
    return ans;
}

const int N = 4e3 + 10;

//int dp[N][N];
//int s[N][N];
//bool u[N][N];
//
//int f (int n, int k) {
//    if (u[n][k]) return dp[n][k];
//    u[n][k] = true;
//    if (k == 0) {
//        u[n][k] = true;
//        dp[n][k] = 0;
//        return dp[n][k];
//    }
//    if (n == 0) {
//        dp[n][k] = 1;
//        s[n][k] = 1;
//        return dp[n][k];
//    }
//    if (n == 1 && k == 1) {
//        dp[n][k] = 1;
//        u[n][k] = true;
//        return dp[n][k];
//    }
//    for (int mid = 0; mid <= n - k; mid++) {
//        f(mid, k);
//        f(n - mid - k, k);
//        int left = s[mid][k];
//        int right = s[n - mid - k][k];
//        dp[n][k] = add(dp[n][k], mul(left, right));
//    }
//    s[n][k] = dp[n][k];
//    f(n, k - 1);
//    s[n][k] = add(s[n][k], s[n][k - 1]);
//    return dp[n][k];
//}

int bin_pow (int x, int k) {
    if (k == 0) return 1;
    if (k == 1) return x;
    if (k & 1) return mul(x, bin_pow(x, k - 1));
    int t = bin_pow(x, k / 2);
    return mul(t, t);
}

int rev (int x) {
    return bin_pow(x, mod - 2);
}

struct Segment {
    int xa, ya, xb, yb;
    Segment () : xa(0), xb(0), ya(0), yb(0) {}
    Segment (int xa, int xb, int ya, int yb) : xa(xa), xb(xb), ya(ya), yb(yb) {}
};

struct Line {
    int a, b, c;
    Line () {}
    Line (Segment d) {
        a = d.yb - d.ya;
        b = d.xa - d.xb;
        c = -d.xa * d.yb + d.xb * d.ya;
    }
};

pair<long double, long double> cross(Line a, Line b) {
    long double d = a.a * b.b - b.a * a.b;
    assert(d != 0);
    long double x = -a.c * b.b + b.c * a.b;
    long double y = -a.a * b.c + b.a * a.c;
    return {x / d, y / d};
}

struct Point {
    int x, y;
    Point () : x(0), y(0) {}
    Point (int x, int y) : x(x), y(y) {}
    bool operator == (const Point &other) {
        return x == other.x && y == other.y;
    }
    int operator ^ (Point other) {
        return x * other.y - y * other.x;
    }
    Point operator - (Point other) {
        return Point (x - other.x, y - other.y);
    }
};

bool ok (Segment a, long double x, long double y) {
    long double Minx = min(a.xa, a.xb);
    long double Maxx = max(a.xa, a.xb);
    long double Miny = min(a.ya, a.yb);
    long double Maxy = max(a.ya, a.yb);
    return Minx <= x && x <= Maxx && Miny <= y && y <= Maxy;
}

bool cross (Segment a, Segment b) {
    Point sa(a.xa, a.ya), sb(a.xb, a.yb);
    Point za(b.xa, b.ya), zb(b.xb, b.yb);
    if (sa == za || sa == zb || sb == za || sb == zb) return true;
    if (((sb - sa) ^ (zb - za)) == 0) return false;
    pair<long double, long double> zxc = cross(Line(a), Line(b));
    return ok(a, zxc.first, zxc.second) && ok(b, zxc.first, zxc.second);
}

int edges = 0;
int cnt = 0;
bool Ok = false;

int c[N];

vector<int> g[N];

void dfs (int u, int p = -1) {
    c[u] = 1;
    cnt++;
    for (auto v : g[u]) {
        if (v == p) continue;
        if (c[v] == 0) dfs(v, u), edges++;
        else if (c[v] == 1) Ok = true, edges++;
    }
    c[u] = 2;
}

void solve() {
    int n;
    cin >> n;
    for (int i = 0; i < n; i++) {
        c[i] = 0;
        g[i].clear();
    }
    vector<Segment> s(n);
    for (int i = 0; i < n; i++) {
        cin >> s[i].xa >> s[i].ya >> s[i].xb >> s[i].yb;
    }
    int ans = 0;
    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            if (cross(s[i], s[j])) g[i].push_back(j), g[j].push_back(i);
        }
    }
    for (int i = 0; i < n; i++) {
        if (!c[i]) {
            cnt = edges = Ok = 0;
            dfs(i);
            if (Ok) ans += edges - cnt + 1;
        }
    }
    ans += 1;
    cout << max(0, ans) << '\n';
}

signed main () {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    cout << fixed << setprecision(15);
#ifdef home
    freopen("in.txt", "r", stdin);
#endif
    int t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
}